<?php
class page
{
	private $db;
	private $page_table;
	private $type_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->page_table=LA_PRE.'page';
		$this->type_table=LA_PRE.'page_type';
	}

	function pagelist($starttime='',$endtime='',$k='')
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';

		$where.=$starttime?' AND inputtime>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND inputtime<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$k?' AND name LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->page_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function getpage($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->page_table` WHERE `$this->page_table`.`id`=$id");
	}

	function pageset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getpage($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->update($this->page_table,$info,'id='.$id);
				}
			}
		}
		return true;
	}

	function page_delete($ids=array(),$userid)
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getpage($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$this->db->mysql_delete($this->page_table,$id);
				}
			}
		}
		return true;
	}

	function admin_page_add($info)
	{
		$info['inputtime']=TIME;
		$info['status']=1;
		$info['siteid']=intval($_SESSION['siteid']);
		return $this->db->insert($this->page_table,$info,true);
	}

	function admin_page_edit($info,$id)
	{
		$info['siteid']=intval($_SESSION['siteid']);
		return $this->db->update($this->page_table,$info,'id='.$id);
	}
	
	function typelist($parentid=0)
	{
		global $page,$_siteid,$siteidobj;
		$moduleid=intval($moduleid);
		$parentid=intval($parentid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$parentid?' AND parentid='.$parentid:' AND parentid=0';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='typeid ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->type_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function type_add($info)
	{
		$info['siteid']=intval($_SESSION['siteid']);
		$info['inputtime']=TIME;
		$names=array_map('trim',explode("|",$info['name']));
		foreach($names as $name)
		{
			if($name)
			{
				$info['name']=strip_tags($name);
				$this->db->insert($this->type_table,$info);
			}
		}
		return true;
	}

	function type_delete($id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}

		$this->db->mysql_delete($this->type_table,intval($id),'typeid');
		return true;
	}

	function gettypeid($moduleid=7)
	{
		$r=$this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`typeid` ASC");
		return $r?$r['typeid']:0;
	}

	function type_edit($info,$id)
	{
		global $_siteid,$siteidobj;
		$id=intval($id);
		$info['inputtime']=TIME;
		$minfo=$this->typeinfo($id);
		if(!$minfo || ($_siteid && !in_array($minfo['siteid'],$siteidobj->getchildid($_siteid))))
		{
			return false;
		}
		return $this->db->update($this->type_table,$info,'typeid='.intval($id));
	}

	function formatpageurl($id)
	{
		global $moduleobj,$configobj,$urlcacheobj,$LA;
		
		$id=intval($id);

		$key='key-page-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$pinfo=$this->getpage($id);
			$url=$LA['siteurl'].'about/index.php?pageid='.$id;
			$urlcacheobj->set($key,$url);
		}

		return $url;
	}

	function typeinfo($id)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`typeid`=".intval($id));
	}

	function typename($id)
	{
		$r=$this->typeinfo($id);
		return $r['name'];
	}


	function type_select($moduleid=7,$parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." AND `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
		}

		return $str;
	}

	function type_select_cat($moduleid=7,$parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)."  AND `$this->type_table`.`parentid`=".intval($parentid)." ORDER BY `$this->type_table`.`typeid` ASC");
		foreach($r as $_r)
		{
			$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
			$r2=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)."  AND `$this->type_table`.`parentid`=".intval($_r['typeid'])." ORDER BY `$this->type_table`.`typeid` ASC");
			foreach($r2 as $_r2)
			{
				$str.='<option value="'.$_r2['typeid'].'">|'.$_r2['name'].'</option>';
			}
		}

		return $str;
	}
}
?>